/*
 * Decompiled with CFR 0.152.
 */
package net.impactdev.impactor.minecraft.ui.containers.views.chests.pagination;

import java.util.Comparator;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.impactdev.impactor.api.ui.containers.Icon;
import net.impactdev.impactor.api.ui.containers.views.pagination.rules.ContextRuleset;
import net.impactdev.impactor.minecraft.ui.containers.views.chests.pagination.PaginatedView;

public class ImpactorContextRuleset
implements ContextRuleset {
    private PaginatedView parent;
    private Predicate<Icon> filter = null;
    private Comparator<Icon> sorter = null;

    public ImpactorContextRuleset with(PaginatedView parent) {
        this.parent = parent;
        return this;
    }

    @Override
    public void filter(Predicate<Icon> filter) {
        this.filter = filter;
        if (this.parent != null) {
            this.parent.update();
        }
    }

    @Override
    public void sorter(Comparator<Icon> sorter) {
        this.sorter = sorter;
        if (this.parent != null) {
            this.parent.update();
        }
    }

    @Override
    public Stream<Icon> apply(Stream<Icon> stream) {
        stream = Optional.ofNullable(this.filter).map(stream::filter).orElse(stream);
        return Optional.ofNullable(this.sorter).map(stream::sorted).orElse(stream);
    }

    public static class ContextRulesetFactory
    implements ContextRuleset.Factory {
        @Override
        public ContextRuleset create() {
            return new ImpactorContextRuleset();
        }
    }
}

